<!DOCTYPE html>
<html lang="en" class="h-full bg-gray-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'WhatsApp Control Panel'); ?></title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <style>
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="h-full">
    <div class="min-h-full">
        <!-- Navigation -->
        <nav class="bg-white border-b border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <span class="text-2xl">💬</span>
                            <span class="ml-2 text-xl font-semibold text-gray-900">WhatsApp Control</span>
                        </div>
                        <div class="hidden sm:ml-8 sm:flex sm:space-x-8">
                            <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center px-1 pt-1 border-b-2 <?php echo e(request()->routeIs('dashboard') ? 'border-green-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> text-sm font-medium">
                                Dashboard
                            </a>
                            <a href="<?php echo e(route('messages.index')); ?>" class="inline-flex items-center px-1 pt-1 border-b-2 <?php echo e(request()->routeIs('messages.*') ? 'border-green-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> text-sm font-medium">
                                Messages
                            </a>
                            <a href="<?php echo e(route('contacts.index')); ?>" class="inline-flex items-center px-1 pt-1 border-b-2 <?php echo e(request()->routeIs('contacts.*') ? 'border-green-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> text-sm font-medium">
                                Contacts
                            </a>
                            <a href="<?php echo e(route('groups.index')); ?>" class="inline-flex items-center px-1 pt-1 border-b-2 <?php echo e(request()->routeIs('groups.*') ? 'border-green-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> text-sm font-medium">
                                Groups
                            </a>
                            <a href="<?php echo e(route('webhooks.config')); ?>" class="inline-flex items-center px-1 pt-1 border-b-2 <?php echo e(request()->routeIs('webhooks.*') ? 'border-green-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> text-sm font-medium">
                                Webhooks
                            </a>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div x-data="healthMonitor()" x-init="init()">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium"
                                  :class="{
                                      'bg-green-100 text-green-800': status === 'connected',
                                      'bg-yellow-100 text-yellow-800': status === 'syncing',
                                      'bg-red-100 text-red-800': status === 'disconnected' || status === 'error',
                                      'bg-gray-100 text-gray-800': status === 'unknown'
                                  }">
                                <span class="w-2 h-2 rounded-full mr-2"
                                      :class="{
                                          'bg-green-500': status === 'connected',
                                          'bg-yellow-500': status === 'syncing',
                                          'bg-red-500': status === 'disconnected' || status === 'error',
                                          'bg-gray-500': status === 'unknown'
                                      }"></span>
                                <span x-text="statusLabel"></span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main content -->
        <main class="py-10">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Alerts -->
                <?php if(session('success')): ?>
                    <div class="mb-6 rounded-md bg-green-50 p-4">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-green-800"><?php echo e(session('success')); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="mb-6 rounded-md bg-red-50 p-4">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-red-800">
                                    <?php echo e($errors->first()); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <script>
        function healthMonitor() {
            return {
                status: 'unknown',
                statusLabel: 'Checking...',
                
                init() {
                    this.checkHealth();
                    setInterval(() => this.checkHealth(), 5000);
                },
                
                async checkHealth() {
                    try {
                        const response = await fetch('/api/health');
                        const data = await response.json();
                        this.status = data.status || 'unknown';
                        this.updateLabel();
                    } catch (error) {
                        this.status = 'error';
                        this.updateLabel();
                    }
                },
                
                updateLabel() {
                    const labels = {
                        'connected': 'Connected',
                        'syncing': 'Syncing',
                        'disconnected': 'Disconnected',
                        'error': 'Error',
                        'unknown': 'Unknown'
                    };
                    this.statusLabel = labels[this.status] || 'Unknown';
                }
            }
        }
    </script>
</body>
</html><?php /**PATH C:\laragon\www\watola\resources\views/layouts/app.blade.php ENDPATH**/ ?>