

<?php $__env->startSection('title', 'Connect WhatsApp'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto" x-data="qrCodeAuth()" x-init="init()">
    <div class="bg-white shadow rounded-lg p-8">
        <div class="text-center">
            <h2 class="text-2xl font-bold text-gray-900 mb-2">Connect WhatsApp</h2>
            <p class="text-sm text-gray-600 mb-8">Scan the QR code with your WhatsApp mobile app</p>

            <div x-show="!authenticated" x-cloak>
                <div class="flex justify-center mb-6">
                    <div class="bg-gray-50 p-8 rounded-lg border-2 border-dashed border-gray-300">
                        <div x-show="loading" class="w-64 h-64 flex items-center justify-center">
                            <svg class="animate-spin h-12 w-12 text-green-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                        </div>
                        <img x-show="!loading && qrCode" :src="qrCode" alt="QR Code" class="w-64 h-64" x-cloak />
                    </div>
                </div>
                
                <div class="space-y-4">
                    <div class="text-sm text-gray-600">
                        <ol class="list-decimal list-inside space-y-2">
                            <li>Open WhatsApp on your phone</li>
                            <li>Tap Menu (⋮) or Settings and select Linked Devices</li>
                            <li>Tap on Link a Device</li>
                            <li>Point your phone at this screen to scan the code</li>
                        </ol>
                    </div>

                    <button @click="refreshQr()" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                        <svg class="mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                        Refresh QR Code
                    </button>
                </div>
            </div>

            <div x-show="authenticated" x-cloak>
                <div class="rounded-full bg-green-100 p-6 inline-block mb-4">
                    <svg class="h-16 w-16 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 mb-2">WhatsApp Connected!</h3>
                <p class="text-gray-600 mb-6">Your WhatsApp account is now connected and ready to use</p>
                <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                    Go to Dashboard
                </a>
            </div>

            <div x-show="error" x-cloak class="mt-4 p-4 bg-red-50 rounded-md">
                <p class="text-sm text-red-800" x-text="error"></p>
            </div>
        </div>
    </div>
</div>

<script>
    function qrCodeAuth() {
        return {
            qrCode: null,
            authenticated: false,
            loading: true,
            error: null,
            intervalId: null,

            init() {
                this.fetchQr();
                this.intervalId = setInterval(() => this.fetchQr(), 10000);
            },

            async fetchQr() {
                try {
                    const response = await fetch('/auth/qr');
                    const data = await response.json();

                    if (data.success) {
                        if (data.authenticated) {
                            this.authenticated = true;
                            clearInterval(this.intervalId);
                        } else {
                            this.qrCode = data.qr;
                        }
                        this.loading = false;
                    } else {
                        this.error = data.message || 'Failed to load QR code';
                        this.loading = false;
                    }
                } catch (err) {
                    this.error = 'Connection error. Please try again.';
                    this.loading = false;
                }
            },

            refreshQr() {
                this.loading = true;
                this.error = null;
                this.fetchQr();
            }
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\watola\resources\views/auth/connect.blade.php ENDPATH**/ ?>