<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\AuthController;

Route::get('/', function () {
    return view('welcome');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
// Dashboard
Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/api/health', [DashboardController::class, 'checkHealth'])->name('api.health');

// WhatsApp Authentication
Route::prefix('auth')->name('auth.')->group(function () {
    Route::get('/connect', [AuthController::class, 'showConnect'])->name('connect');
    Route::get('/qr', [AuthController::class, 'getQrCode'])->name('qr');
});

// Messages
Route::prefix('messages')->name('messages.')->group(function () {
    Route::get('/', [MessageController::class, 'index'])->name('index');
    Route::get('/send', [MessageController::class, 'create'])->name('create');
    Route::post('/send', [MessageController::class, 'send'])->name('send');
    Route::post('/reply', [MessageController::class, 'reply'])->name('reply');
    Route::post('/send-file', [MessageController::class, 'sendFile'])->name('send.file');
});

// Contacts
Route::prefix('contacts')->name('contacts.')->group(function () {
    Route::get('/', [ContactController::class, 'index'])->name('index');
    Route::get('/{id}', [ContactController::class, 'show'])->name('show');
});

// Groups
Route::prefix('groups')->name('groups.')->group(function () {
    Route::get('/', [GroupController::class, 'index'])->name('index');
    Route::get('/broadcast', [GroupController::class, 'showBroadcast'])->name('broadcast.show');
    Route::post('/broadcast', [GroupController::class, 'broadcast'])->name('broadcast');
    Route::get('/{id}', [GroupController::class, 'show'])->name('show');
});

// Webhooks
Route::prefix('webhooks')->name('webhooks.')->group(function () {
    Route::get('/config', [WebhookController::class, 'config'])->name('config');
    Route::post('/config', [WebhookController::class, 'update'])->name('update');
    Route::post('/listen', [WebhookController::class, 'toggleListen'])->name('listen');
});

require __DIR__.'/auth.php';
