@extends('layouts.app')

@section('title', 'Webhook Configuration')

@section('content')
<div class="max-w-3xl mx-auto space-y-6">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Webhook Configuration</h1>
        <p class="mt-1 text-sm text-gray-500">Configure webhook URL to receive real-time message notifications</p>
    </div>

    <!-- Current Webhook -->
    @if($currentWebhook)
        <div class="bg-green-50 border-l-4 border-green-400 p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-green-700">
                        <strong>Active webhook:</strong> {{ $currentWebhook }}
                    </p>
                </div>
            </div>
        </div>
    @endif

    <!-- Webhook Form -->
    <div class="bg-white shadow rounded-lg p-6">
        <form action="{{ route('webhooks.update') }}" method="POST" class="space-y-6">
            @csrf
            
            <div>
                <label for="webhook_url" class="block text-sm font-medium text-gray-700">Webhook URL</label>
                <div class="mt-1">
                    <input type="url" id="webhook_url" name="webhook_url" value="{{ old('webhook_url', $currentWebhook) }}" required class="shadow-sm focus:ring-green-500 focus:border-green-500 block w-full sm:text-sm border-gray-300 rounded-md" placeholder="https://your-domain.com/webhook">
                </div>
                <p class="mt-2 text-sm text-gray-500">
                    Enter the URL where you want to receive incoming message notifications
                </p>
            </div>

            <div class="bg-gray-50 p-4 rounded-md">
                <h4 class="text-sm font-medium text-gray-900 mb-2">Webhook Payload Example</h4>
                <pre class="text-xs text-gray-600 overflow-x-auto"><code>{
  "from": "1234567890@c.us",
  "to": "0987654321@c.us",
  "message": "Hello, World!",
  "timestamp": "2025-01-15T10:30:00Z",
  "messageId": "ABC123XYZ"
}</code></pre>
            </div>

            <div class="flex justify-end space-x-3">
                <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                    Save Webhook
                </button>
            </div>
        </form>
    </div>

    <!-- Message Listening -->
    <div class="bg-white shadow rounded-lg p-6" x-data="{ listening: false }">
        <div class="flex items-center justify-between">
            <div>
                <h3 class="text-lg font-medium text-gray-900">Message Listening</h3>
                <p class="mt-1 text-sm text-gray-500">Enable or disable incoming message notifications</p>
            </div>
            <button @click="toggleListen()" type="button" role="switch" :aria-checked="listening" :class="listening ? 'bg-green-600' : 'bg-gray-200'" class="relative inline-flex flex-shrink-0 h-6 w-11 border-2 border-transparent rounded-full cursor-pointer transition-colors ease-in-out duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                <span class="sr-only">Toggle listening</span>
                <span :class="listening ? 'translate-x-5' : 'translate-x-0'" class="pointer-events-none inline-block h-5 w-5 rounded-full bg-white shadow transform ring-0 transition ease-in-out duration-200"></span>
            </button>
        </div>
    </div>
</div>

<script>
    async function toggleListen() {
        try {
            const response = await fetch('/webhooks/listen', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ enable: !this.listening })
            });

            const data = await response.json();
            if (data.success) {
                this.listening = !this.listening;
            }
        } catch (error) {
            console.error('Failed to toggle listening:', error);
        }
    }
</script>
@endsection