<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Settings') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8 space-y-6">
            @if(session('success'))
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif
            @if(session('error'))
                <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif

            <!-- Webhook Settings -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900">Webhook Configuration</h3>
                    <p class="mt-1 text-sm text-gray-600">
                        Set a URL to receive incoming messages and events in real-time.
                    </p>

                    <form action="{{ route('settings.webhook.set') }}" method="POST" class="mt-6">
                        @csrf
                        <div class="flex items-end">
                            <div class="flex-grow">
                                <label for="webhook_url" class="block text-sm font-medium text-gray-700">Webhook URL</label>
                                <input type="url" name="webhook_url" id="webhook_url" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md" placeholder="https://example.com/webhook" value="{{ $webhook['url'] ?? '' }}">
                            </div>
                            <div class="ml-3">
                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                    Save
                                </button>
                            </div>
                        </div>
                         @error('webhook_url')
                            <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </form>
                </div>
            </div>

            <!-- Listener Settings -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                     <h3 class="text-lg font-medium text-gray-900">Message Listener</h3>
                    <p class="mt-1 text-sm text-gray-600">
                        Toggle the master switch to start or stop the server from listening for new messages. This does not affect webhook delivery.
                    </p>

                    <div class="mt-6 flex space-x-4">
                        <form action="{{ route('settings.listener.toggle') }}" method="POST">
                            @csrf
                            <input type="hidden" name="enabled" value="1">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-500 active:bg-green-700 focus:outline-none focus:border-green-700 focus:ring ring-green-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Start Listening
                            </button>
                        </form>
                         <form action="{{ route('settings.listener.toggle') }}" method="POST">
                            @csrf
                            <input type="hidden" name="enabled" value="0">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-red-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-red-500 active:bg-red-700 focus:outline-none focus:border-red-700 focus:ring ring-red-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Stop Listening
                            </button>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>
