<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Compose Message') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif
            @if(session('error'))
                <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('error') }}</span>
                </div>
            @endif

            <div x-data="{ tab: 'message' }" class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="border-b border-gray-200">
                        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                            <button @click="tab = 'message'" :class="tab === 'message' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Send Text Message
                            </button>
                            <button @click="tab = 'file'" :class="tab === 'file' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Send File
                            </button>
                        </nav>
                    </div>

                    {{-- Text Message Form --}}
                    <div x-show="tab === 'message'" class="mt-6">
                        <form action="{{ route('messages.send') }}" method="POST">
                            @csrf
                            <div class="mb-4">
                                <label for="recipient" class="block text-sm font-medium text-gray-700">Recipient</label>
                                <select id="recipient" name="recipient" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                                    <option selected disabled>Select a recipient</option>
                                    <optgroup label="Contacts">
                                        @forelse($contacts as $contact)
                                            @if(!empty($contact['id']) && !empty($contact['name']))
                                                <option value="{{ $contact['id'] }}">{{ $contact['name'] }} ({{ $contact['id'] }})</option>
                                            @endif
                                        @empty
                                            <option disabled>No contacts found</option>
                                        @endforelse
                                    </optgroup>
                                    <optgroup label="Groups">
                                        @forelse($groups as $group)
                                             @if(!empty($group['id']) && !empty($group['name']))
                                                <option value="{{ $group['id'] }}">{{ $group['name'] }}</option>
                                            @endif
                                        @empty
                                            <option disabled>No groups found</option>
                                        @endforelse
                                    </optgroup>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label for="message" class="block text-sm font-medium text-gray-700">Message</label>
                                <textarea id="message" name="message" rows="4" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md" required>{{ old('message') }}</textarea>
                            </div>

                            <div class="flex justify-end">
                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                    Send Message
                                </button>
                            </div>
                        </form>
                    </div>

                    {{-- File Sending Form --}}
                     <div x-show="tab === 'file'" class="mt-6" style="display: none;">
                        <form action="{{ route('messages.send.file') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                             <div class="mb-4">
                                <label for="recipient_file" class="block text-sm font-medium text-gray-700">Recipient</label>
                                <select id="recipient_file" name="recipient" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                                    <option selected disabled>Select a recipient</option>
                                    <optgroup label="Contacts">
                                        @forelse($contacts as $contact)
                                            @if(!empty($contact['id']) && !empty($contact['name']))
                                                <option value="{{ $contact['id'] }}">{{ $contact['name'] }} ({{ $contact['id'] }})</option>
                                            @endif
                                        @empty
                                            <option disabled>No contacts found</option>
                                        @endforelse
                                    </optgroup>
                                    <optgroup label="Groups">
                                        @forelse($groups as $group)
                                             @if(!empty($group['id']) && !empty($group['name']))
                                                <option value="{{ $group['id'] }}">{{ $group['name'] }}</option>
                                            @endif
                                        @empty
                                            <option disabled>No groups found</option>
                                        @endforelse
                                    </optgroup>
                                </select>
                            </div>

                            <div class="mb-4">
                                <label for="file" class="block text-sm font-medium text-gray-700">File</label>
                                <input type="file" name="file" id="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100" required>
                            </div>

                            <div class="mb-4">
                                <label for="caption" class="block text-sm font-medium text-gray-700">Caption (Optional)</label>
                                <input type="text" id="caption" name="caption" class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md" value="{{ old('caption') }}">
                            </div>

                            <div class="flex justify-end">
                                <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-500 active:bg-indigo-700 focus:outline-none focus:border-indigo-700 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                    Send File
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
