<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ $group['subject'] ?? 'Group Details' }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    @if($group)
                        <div class="mb-6">
                            <h3 class="text-lg leading-6 font-medium text-gray-900">
                                Group Information
                            </h3>
                            <div class="mt-2 border-t border-gray-200 pt-2">
                                <dl class="divide-y divide-gray-200">
                                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4">
                                        <dt class="text-sm font-medium text-gray-500">Subject</dt>
                                        <dd class="mt-1 flex text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                                            <span class="flex-grow">{{ $group['subject'] }}</span>
                                        </dd>
                                    </div>
                                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4">
                                        <dt class="text-sm font-medium text-gray-500">Group ID</dt>
                                        <dd class="mt-1 flex text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                                            <span class="flex-grow">{{ $group['id'] }}</span>
                                        </dd>
                                    </div>
                                    <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4">
                                        <dt class="text-sm font-medium text-gray-500">Participants</dt>
                                        <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                                            {{ count($group['participants']) }} members
                                        </dd>
                                    </div>
                                </dl>
                            </div>
                        </div>


                        <div>
                             <h3 class="text-lg leading-6 font-medium text-gray-900">
                                Participants
                            </h3>
                            <ul role="list" class="mt-2 divide-y divide-gray-200 border-t border-gray-200">
                                @foreach($group['participants'] as $participant)
                                <li class="py-4 flex">
                                    <div class="ml-3">
                                        <p class="text-sm font-medium text-gray-900">{{ $participant['id'] }}</p>
                                        <p class="text-sm text-gray-500">
                                            @if($participant['isAdmin'])
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                    Admin
                                                </span>
                                            @else
                                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                                    Member
                                                </span>
                                            @endif
                                        </p>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                        </div>

                    @else
                        <p class="text-center text-gray-500">Could not retrieve group details.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
