@extends('layouts.app')

@section('title', 'Groups')

@section('content')
<div class="space-y-6">
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Groups</h1>
            <p class="mt-1 text-sm text-gray-500">{{ count($groups) }} groups</p>
        </div>
        <a href="{{ route('groups.broadcast.show') }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
            <svg class="mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"/>
            </svg>
            Broadcast Message
        </a>
    </div>

    <!-- Search -->
    <form action="{{ route('groups.index') }}" method="GET" class="bg-white shadow rounded-lg p-4">
        <div class="flex gap-3">
            <input type="text" name="search" value="{{ $search }}" placeholder="Search groups..." class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-green-500 focus:border-green-500 sm:text-sm">
            <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                Search
            </button>
            @if($search)
                <a href="{{ route('groups.index') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                    Clear
                </a>
            @endif
        </div>
    </form>

    <!-- Groups List -->
    <div class="bg-white shadow rounded-lg">
        @forelse($groups as $group)
            <div class="border-b border-gray-200 last:border-b-0 p-6 hover:bg-gray-50 transition-colors">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-4 flex-1">
                        <div class="flex-shrink-0">
                            <div class="h-14 w-14 rounded-full bg-purple-100 flex items-center justify-center">
                                <span class="text-xl font-semibold text-purple-600">
                                    {{ substr($group['name'] ?? '?', 0, 1) }}
                                </span>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-base font-medium text-gray-900 truncate">
                                {{ $group['name'] ?? 'Unknown Group' }}
                            </p>
                            <p class="text-sm text-gray-500">
                                {{ $group['size'] ?? 0 }} members
                            </p>
                        </div>
                    </div>
                    <div class="flex space-x-2">
                        <a href="{{ route('messages.create') }}?to={{ $group['id'] }}" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                            Message
                        </a>
                    </div>
                </div>
            </div>
        @empty
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No groups found</h3>
                <p class="mt-1 text-sm text-gray-500">
                    @if($search)
                        Try a different search term
                    @else
                        Your groups will appear here once synced
                    @endif
                </p>
            </div>
        @endforelse
    </div>
</div>
@endsection