@extends('layouts.app')

@section('title', 'Contacts')

@section('content')
<div class="space-y-6">
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Contacts</h1>
            <p class="mt-1 text-sm text-gray-500">{{ count($contacts) }} contacts</p>
        </div>
    </div>

    <!-- Search -->
    <form action="{{ route('contacts.index') }}" method="GET" class="bg-white shadow rounded-lg p-4">
        <div class="flex gap-3">
            <input type="text" name="search" value="{{ $search }}" placeholder="Search contacts..." class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-green-500 focus:border-green-500 sm:text-sm">
            <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                Search
            </button>
            @if($search)
                <a href="{{ route('contacts.index') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                    Clear
                </a>
            @endif
        </div>
    </form>

    <!-- Contacts Grid -->
    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3">
        @forelse($contacts as $contact)
            <div class="bg-white shadow rounded-lg p-6 hover:shadow-md transition-shadow">
                <div class="flex items-center space-x-4">
                    <div class="flex-shrink-0">
                        <div class="h-12 w-12 rounded-full bg-green-100 flex items-center justify-center">
                            <span class="text-lg font-semibold text-green-600">
                                {{ substr($contact['name'] ?? $contact['pushname'] ?? $contact['id'] ?? '?', 0, 1) }}
                            </span>
                        </div>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-gray-900 truncate">
                            {{ $contact['name'] ?? $contact['pushname'] ?? 'Unknown' }}
                        </p>
                        <p class="text-sm text-gray-500 truncate">
                            {{ $contact['id'] ?? '' }}
                        </p>
                    </div>
                </div>
                <div class="mt-4">
                    <a href="{{ route('messages.create') }}?to={{ $contact['id'] }}" class="w-full inline-flex justify-center items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Send Message
                    </a>
                </div>
            </div>
        @empty
            <div class="col-span-full">
                <div class="text-center py-12 bg-white rounded-lg shadow">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No contacts found</h3>
                    <p class="mt-1 text-sm text-gray-500">
                        @if($search)
                            Try a different search term
                        @else
                            Your contacts will appear here once synced
                        @endif
                    </p>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection