<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Connect WhatsApp') }}
        </h2>
    </x-slot>

    <div class="py-12" x-data="whatsappAuth" x-init="init">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200 text-center">
                    <div x-show="!qrCode.base64 && !connection.connected">
                        <p class="text-gray-600 mb-4">Loading QR Code...</p>
                        <div class="flex justify-center items-center">
                            <svg class="animate-spin h-8 w-8 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                        </div>
                    </div>

                    <div x-show="qrCode.base64">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Scan this QR Code</h3>
                        <p class="text-sm text-gray-500 mb-4">Open WhatsApp on your phone, go to Settings > Linked Devices, and scan the code.</p>
                        <img :src="qrCode.base64" alt="WhatsApp QR Code" class="mx-auto rounded-lg shadow-md">
                        <p class="text-xs text-gray-500 mt-4" x-text="qrCode.message"></p>
                    </div>

                    <div x-show="connection.connected">
                        <h3 class="text-lg font-medium text-gray-900 mb-2">WhatsApp is Connected!</h3>
                        <p class="text-gray-600">You can now proceed to the dashboard.</p>
                        <div class="mt-6">
                            <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-500 active:bg-green-700 focus:outline-none focus:border-green-700 focus:ring ring-green-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Go to Dashboard
                            </a>
                        </div>
                    </div>

                     <div x-show="connection.error">
                        <h3 class="text-lg font-medium text-red-700 mb-2">Connection Error</h3>
                        <p class="text-gray-600" x-text="connection.errorMessage"></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('whatsappAuth', () => ({
                qrCode: {},
                connection: {
                    connected: false,
                    error: false,
                    errorMessage: ''
                },
                init() {
                    this.fetchQrCode();
                    this.pollStatus();
                },
                fetchQrCode() {
                    fetch('{{ route("api.qr") }}')
                        .then(response => response.json())
                        .then(data => {
                            if (data.qr) {
                                this.qrCode = data.qr;
                            } else {
                                this.handleError('Failed to load QR code.');
                            }
                        })
                        .catch(() => this.handleError('Could not communicate with the server to get a QR code.'));
                },
                pollStatus() {
                    let poll = setInterval(() => {
                        fetch('{{ route("api.status") }}')
                            .then(response => response.json())
                            .then(data => {
                                if (data.status && data.status.state === 'CONNECTED') {
                                    this.connection.connected = true;
                                    this.qrCode = {};
                                    clearInterval(poll);
                                }
                            });
                    }, 3000);
                },
                handleError(message) {
                    this.connection.error = true;
                    this.connection.errorMessage = message;
                }
            }))
        })
    </script>
</x-app-layout>
