<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhatsAppApiService;
use Illuminate\View\View;
use Exception;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
        protected WhatsAppApiService $whatsappApi;

    public function __construct(WhatsAppApiService $whatsappApi)
    {
       $this->whatsappApi = $whatsappApi;
    }
    //
    public function config()
    {
        $webhook = $this->whatsappApi->getWebhook();
        return view('webhooks.config', [
            'currentWebhook' => $webhook['webhook'] ?? null
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'webhook_url' => 'required|url|max:500'
        ]);

        $result = $this->whatsappApi->setWebhook($validated['webhook_url']);

        if ($result['success']) {
            return redirect()->route('webhooks.config')
                ->with('success', 'Webhook configured successfully');
        }

        return back()->withErrors(['error' => $result['message']]);
    }

    public function toggleListen(Request $request)
    {
        $validated = $request->validate([
            'enable' => 'required|boolean'
        ]);

        $result = $this->whatsappApi->toggleListen($validated['enable']);

        return response()->json($result);
    }

}
