<?php

namespace App\Http\Controllers;

use App\Services\WhatsAppApiService;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Exception;
use Illuminate\Support\Facades\Log;

class SettingsController extends Controller
{
    protected WhatsAppApiService $whatsappService;

    public function __construct(WhatsAppApiService $whatsappService)
    {
       $this->whatsappApi = $whatsappService;
    }

    /**
     * Display the settings page.
     *
     * @return \Illuminate\View\View
     */
    public function index(): View
    {
        $webhook = [];
        try {
            $webhook =$this->whatsappApi->getWebhook();
        } catch (Exception $e) {
            //
        }
        return view('settings.index', compact('webhook'));
    }

    /**
     * Set the webhook URL.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function setWebhook(Request $request)
    {
        $request->validate([
            'webhook_url' => 'required|url'
        ]);

        try {
           $this->whatsappApi->setWebhook($request->webhook_url);
            return back()->with('success', 'Webhook URL updated successfully!');
        } catch (Exception $e) {
            return back()->with('error', 'Failed to update webhook: ' . $e->getMessage());
        }
    }

    /**
     * Toggle message listening.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function toggleListening(Request $request)
    {
        $request->validate([
            'enabled' => 'required|boolean',
        ]);

        try {
           $this->whatsappApi->toggleListening($request->enabled);
            $action = $request->enabled ? 'started' : 'stopped';
            return back()->with('success', "Message listening has been {$action}.");
        } catch (Exception $e) {
            return back()->with('error', 'Failed to toggle listening: ' . $e->getMessage());
        }
    }
}
