<?php

namespace App\Http\Controllers;

use App\Services\WhatsAppApiService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Exception;
use Illuminate\Support\Facades\Log;

class DashboardController extends Controller
{
    protected WhatsAppApiService $whatsappApi;

    public function __construct(WhatsAppApiService $whatsappApi)
    {
       $this->whatsappApi = $whatsappApi;
    }

    /**
     * Display the main dashboard.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $health = $this->whatsappApi->getHealthStatus();
        
        return view('dashboard', [
            'connectionStatus' => $health['status'] ?? 'unknown',
            'isConnected' => ($health['status'] ?? '') === 'connected'
        ]);
    }

    public function checkHealth()
    {
        $health = $this->whatsappApi->getHealthStatus();
        return response()->json($health);
    }
}