<?php

namespace App\Http\Controllers;

use App\Services\WhatsAppApiService;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Exception;
use Illuminate\Support\Facades\Log;

class ContactController extends Controller
{
    protected WhatsAppApiService $whatsappApi;

    public function __construct(WhatsAppApiService $whatsappApi)
    {
       $this->whatsappApi = $whatsappApi;
    }

    /**
     * Display a list of contacts.
     *
     * @return \Illuminate\View\View
     */
     public function index(Request $request)
    {
        $contacts = $this->whatsappApi->getContacts();
        $search = $request->query('search');

        $filteredContacts = $contacts['contacts'] ?? [];

        if ($search) {
            $filteredContacts = array_filter($filteredContacts, function ($contact) use ($search) {
                $name = $contact['name'] ?? $contact['pushname'] ?? '';
                return stripos($name, $search) !== false || 
                       stripos($contact['id'], $search) !== false;
            });
        }

        return view('contacts.index', [
            'contacts' => $filteredContacts,
            'search' => $search
        ]);
    }

    public function show(string $id)
    {
        $contact = $this->whatsappApi->getContact($id);
        
        if (!$contact['success']) {
            return redirect()->route('contacts.index')
                ->withErrors(['error' => 'Contact not found']);
        }

        return view('contacts.show', ['contact' => $contact['contact']]);
    }
}