<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

## About This Project

This is a Laravel-based control panel for a pre-existing WhatsApp API. It provides a simple and elegant interface to monitor connection status, manage authentication via QR code, send and receive messages, view contacts and groups, and configure webhooks.

---

## Setup Instructions

### 1. Prerequisites
- PHP >= 8.2
- Composer
- Node.js & NPM
- A database (MySQL, PostgreSQL, or SQLite)

### 2. Installation
1.  **Clone the repository:**
    ```bash
    git clone <repository_url>
    cd <repository_directory>
    ```
2.  **Install PHP dependencies:**
    ```bash
    composer install
    ```
3.  **Install JavaScript dependencies:**
    ```bash
    npm install && npm run build
    ```
4.  **Create your environment file:**
    ```bash
    cp .env.example .env
    ```
5.  **Generate an application key:**
    ```bash
    php artisan key:generate
    ```

### 3. Configuration
1.  **Database:**
    Open the `.env` file and configure your database connection details (`DB_CONNECTION`, `DB_HOST`, `DB_PORT`, `DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`).
2.  **WhatsApp API URL:**
    The `.env` file should contain the `WHATSAPP_API_URL`. Ensure it points to the correct endpoint of your hosted WhatsApp service.
    ```
    WHATSAPP_API_URL=http://16.171.159.247:3000
    ```
3.  **Run database migrations:**
    This will create the necessary tables for users and sessions.
    ```bash
    php artisan migrate
    ```

### 4. Running the Application
1.  **Start the development server:**
    ```bash
    php artisan serve
    ```
2.  **Access the application:**
    Open your browser and navigate to `http://127.0.0.1:8000`.

### 5. Creating a User
To use the authenticated sections, you will need a user account. You can create one using Laravel's Tinker:
```bash
php artisan tinker
```
Then run the following code, replacing the example data with your own:
```php
\App\Models\User::create([
    'name' => 'Your Name',
    'email' => 'your@email.com',
    'password' => bcrypt('your_password')
]);
```
You can now log in with these credentials.

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.